/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/

/* ---------------------------------------------------------------
 * File: xrt.h 
 *       Prototypes for Requester-Target (RT) Functions
 * -----------------------------------------------------------------*/

#ifndef XREQUESTER_H_INCLUDED                               
#define XREQUESTER_H_INCLUDED

#include <xrtdefs.h>

#ifndef CLI
#define CLI
#endif

#ifdef __cplusplus
extern "C" {
#endif

/********************************************************************
  RT programming ****************************************************
 ********************************************************************/

CLI bx_errtype EXPORT BestXRTProg(            /* @rtprog */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXRTRead(            /* @rtread */
  bx_handletype  handle,
  bx_int32 option
);


/********************************************************************
  RT generics *******************************************************
 *******************************************************************/

CLI bx_errtype EXPORT BestXRTGenDefaultSet(   /* @rtgendefset */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXRTGenGet(          /* @rtgenget */
  bx_handletype  handle,
  bx_rtgentype prop,                                
  bx_int32       *val                         /* #RETURN "0x%08lx" */
);

CLI bx_errtype EXPORT BestXRTGenSet(          /* @rtgenset */
  bx_handletype  handle,
  bx_rtgentype prop,                                
  bx_int32       val                               
);

CLI bx_errtype EXPORT BestXRTGenProg(          /* @rtgenprog */
  bx_handletype        handle
);

CLI bx_errtype EXPORT BestXRTGenRead(          /* @rtgenread */
  bx_handletype        handle
);

/********************************************************************
  RT behavior *******************************************************
 *******************************************************************/

CLI  bx_errtype EXPORT BestXRTBehMemInit(     /* @rtbehmeminit */
  bx_handletype handle
);

CLI  bx_errtype EXPORT BestXRTBehDefaultSet(  /* @rtbehdefset */
  bx_handletype handle,
  bx_int32 offset
);

CLI bx_errtype EXPORT BestXRTBehSet(          /* @rtbehset */
  bx_handletype handle,
  bx_int32 offset,
  bx_rtbehtype prop,                                     
  bx_int32 val                                       
);

CLI  bx_errtype EXPORT BestXRTBehGet(         /* @rtbehget */      
  bx_handletype handle,
  bx_int32 offset,
  bx_rtbehtype prop,                                     
  bx_int32   *val                             /* #RETURN "0x%08lx" */
);

CLI bx_errtype EXPORT BestXRTBehProg(         /* @rtbehprog */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXRTBehRead(         /* @rtbehread */
  bx_handletype  handle,
  bx_int32 option
);

CLI bx_errtype EXPORT BestXRTBehCopyLine(     /* @rtbehcopyline */
  bx_handletype  handle,
  bx_int32 srcline,
  bx_int32 destline
);

#ifdef __cplusplus
}
#endif

#endif
